//
//  GSNotifyingDictionary.h
//  GlyphsCore
//
//  Created by Georg Seifert on 29.09.14.
//  Copyright (c) 2014 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSElement;
#import <GlyphsCore/GSContainerProtocol.h>

@interface GSNotifyingDictionary : NSObject

@property (weak, nonatomic) GSContainer *parent;

- (instancetype)initWithDictionary:(NSDictionary *)dict;
- (void)setObject:(id)value forKey:(id)key;
- (void)setObject:(id)value forKeyedSubscript:(id)key;
- (void)removeObjectForKey:(id)key;
- (id)objectForKey:(id)key;
- (id)objectForKeyedSubscript:(id)key;
- (NSArray *)allKeys;
- (NSArray *)allValues;
- (NSUInteger)count;
- (NSDictionary *)dict;
@end
